/**
* \file: blacklist.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_CONTROL_BLACKLIST_H
#define AAM_CONTROL_BLACKLIST_H

#include <stdbool.h>

#include "automounter_types.h"

error_code_t blacklist_init(void);

void blacklist_deinit(void);

void blacklist_add_blacklisted_device(const char* device_id);

void blacklist_add_blacklisted_partition(const char* partition_id);

void blacklist_add_supported_fs_array(char* fstype_array);

bool blacklist_is_device_blacklisted(const char* device_id);

bool blacklist_is_partition_blacklisted(const char* partition_id);

bool blacklist_is_fs_supported(const char *fstype);

bool blacklist_is_system_device(const char *mount_src);

#endif
